package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@Builder
@AllArgsConstructor
public class PavilionInfoDTO implements Serializable {

  /** 主键id */
  private Long id;
  /**
   * 名称
   */
  private String pavilionName;

  /**
   * 纬度
   */
  private String latitude;

  /**
   * 经度
   */
  private String longitude;

  /**
   * 详细地址
   */
  private String detailAddress;

  /**
   * 营业时间
   */
  private String businessHours;

  /**
   * 类型
   */
  private String pavilionType;

  /**
   * 所在的地区
   */
  private String areaName;


  /**
   * 纬度
   */
  private BigDecimal latitudeB;

  /**
   * 经度
   */
  private BigDecimal longitudeB;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getPavilionName() {
    return pavilionName;
  }

  public void setPavilionName(String pavilionName) {
    this.pavilionName = pavilionName;
  }

  public String getLatitude() {
    return latitude;
  }

  public void setLatitude(String latitude) {
    this.latitude = latitude;
  }

  public String getLongitude() {
    return longitude;
  }

  public void setLongitude(String longitude) {
    this.longitude = longitude;
  }

  public String getDetailAddress() {
    return detailAddress;
  }

  public void setDetailAddress(String detailAddress) {
    this.detailAddress = detailAddress;
  }

  public String getBusinessHours() {
    return businessHours;
  }

  public void setBusinessHours(String businessHours) {
    this.businessHours = businessHours;
  }

  public String getPavilionType() {
    return pavilionType;
  }

  public void setPavilionType(String pavilionType) {
    this.pavilionType = pavilionType;
  }

  public String getAreaName() {
    return areaName;
  }

  public void setAreaName(String areaName) {
    this.areaName = areaName;
  }

  public BigDecimal getLatitudeB() {
    if (StringUtils.isNotBlank(this.getLatitude())) {
      return new BigDecimal(this.getLatitude());
    }
    return latitudeB;
  }

  public void setLatitudeB(BigDecimal latitudeB) {
    this.latitudeB = latitudeB;
  }

  public BigDecimal getLongitudeB() {
    if (StringUtils.isNotBlank(this.getLongitude())) {
      return new BigDecimal(this.getLongitude());
    }
    return longitudeB;
  }

  public void setLongitudeB(BigDecimal longitudeB) {
    this.longitudeB = longitudeB;
  }

}
