package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.ScheduleRequestDTO;
import com.beiming.odr.user.api.dto.responsedto.RecommendAppResDTO;
import java.util.ArrayList;

/**
 * @author jiangfan
 * @date 2024/06/27
 */
public interface ScheduleServiceApi {

  /**
   * 新增日程
   * @param dto
   * @return
   */
  DubboResult insert(ScheduleRequestDTO dto);

  /**
   * 修改日程
   * @param dto
   * @return
   */
  DubboResult update(ScheduleRequestDTO dto);

  /**
   * 日程列表
   * @param dto
   * @return
   */
  DubboResult list(ScheduleRequestDTO dto);

  /**
   * 推荐应用
   * @return
   */
  DubboResult<ArrayList<RecommendAppResDTO>> recommendAppList();

  DubboResult<ArrayList<String>> calendar(String date, String userId);
}
