package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserCertificatesTypeEnum;
import com.beiming.odr.user.api.dto.UserCertificateInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.BatchUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * 用户api中已经放不下了，特此新建第二个用户api
 */
@Valid
public interface UserServiceSecondApi {

  DubboResult<Boolean> ifFacialVerify();

  /**
   * 批量注册 用过手机号码列表
   * 不做数据的任何校验，就做简单的插入。数据校验，调用该接口时，自己校验
   */
  DubboResult<ArrayList<BatchUserRegisterResDTO>> batchUserRegister(Map<String, String> idCardMap);

  DubboResult<String> getESignAccountId(@Valid @NotNull Long userId);

  DubboResult updateUserRoleStatus(List<Long> orgIds, Long userId, String status, Integer enable);

  DubboResult<CommonUserSearchResDTO> searchUserByIdCard(String idCard, PersonTypeEnum personTypeEnum);

  DubboResult<ArrayList<CommonUserSearchResDTO>> searchUserByIds(List<Long> userIds);

  /**
   * 查询用户证件
   */
  DubboResult<ArrayList<UserCertificateInfoDTO>> searchUserCertificates(Long userId, UserCertificatesTypeEnum userCertificatesTypeEnum);
}
