package com.beiming.odr.user.api.dto;

import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xiaoying
 * @date 2022/03/04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class CheckUserDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户性别
   */
  private String userSex;

  /**
   * 组织机构名称
   */
  private String orgName;

  /**
   * 联系电话
   */
  @EncryptDecryptField
  private String phone;


}