package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * Created by Jache on 2019/01/23 14:22.
 */
@Data
public class UserQrCodeLoginReqDTO implements Serializable {

  private static final long serialVersionUID = 1931136147337487473L;
  /**
   * 手机号
   */
  @NotBlank(message = "{user.phoneNotBlank}")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  private String phone;
  private String idCard;
  private String name;
  private Boolean isShowQrCode;
}
