/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.common.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Java8DateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_CN_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String DATE_MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    public static final String START_TIME = " 00:00:00";
    public static final String END_TIME = " 23:59:59";
    public static final String SECOND_START = ":00";
    public static final String SECOND_END = ":59";

    public static Date getDate(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
        LocalDateTime localDateTime = LocalDateTime.parse(date, formatter);
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDateTime.atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date getDate(LocalDate localDate) {
        ZoneId zone = ZoneId.systemDefault();
        Instant instant = localDate.atStartOfDay().atZone(zone).toInstant();
        return Date.from(instant);
    }

    public static Date getDate(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static LocalDateTime getLocalDateTime(String date) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
        return LocalDateTime.parse(date, formatter);
    }

    public static LocalDateTime getLocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        return LocalDateTime.ofInstant(instant, zone);
    }

    public static LocalDate getLocalDate(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static LocalDate getLocalDate(String dateStr) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT);
        return LocalDate.parse(dateStr, formatter);
    }

    public static String getCurrentYear() {
        return String.valueOf(LocalDate.now().getYear());
    }

    public static String getCurrentMonth() {
        String month = String.valueOf(LocalDate.now().getMonthValue());
        if (month.length() == 1) {
            return "0" + month;
        }
        return month;
    }

    public static String getCurrentDayOfMonth() {
        String day = String.valueOf(LocalDate.now().getDayOfMonth());
        if (day.length() == 1) {
            return "0" + day;
        }
        return day;
    }

    public static String formatter(Date date, String pattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = Java8DateUtil.getLocalDateTime(date);
        return localDateTime.format(dateFormatter);
    }

    public static String formatter(String date, String sourcePattern, String targetPattern) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(targetPattern);
        DateTimeFormatter sourceFormatter = DateTimeFormatter.ofPattern(sourcePattern);
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(date, sourceFormatter);
            return localDateTime.format(dateFormatter);
        }
        catch (Exception e) {
            LocalDate localDateTime = LocalDate.parse(date, sourceFormatter);
            return localDateTime.format(dateFormatter);
        }
    }

    public static Map<String, String> firstLastDay(String cycle) {
        LocalDate now = LocalDate.now();
        LocalDate beginDay = null;
        LocalDate endDay = null;
        if ("THIS_WEEK".equals(cycle)) {
            beginDay = now.with(TemporalAdjusters.previous(DayOfWeek.SUNDAY)).plusDays(1L);
            endDay = now.with(TemporalAdjusters.next(DayOfWeek.MONDAY)).minusDays(1L);
        } else if ("THIS_MONTH".equals(cycle)) {
            beginDay = now.with(TemporalAdjusters.firstDayOfMonth());
            endDay = now.with(TemporalAdjusters.lastDayOfMonth());
        } else {
            return null;
        }
        HashMap<String, String> daysMap = new HashMap<String, String>();
        daysMap.put("beginDay", beginDay.toString());
        daysMap.put("endDay", endDay.toString());
        System.out.println(((Object)daysMap).toString());
        return daysMap;
    }
}

