package com.beiming.odr.user.api;


import java.util.List;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;

/**
 * 字典
 *
 * @author fhs
 * @date 2018年6月13日
 */
public interface DictionaryServiceApi {

  /**
   * 根据parentCode 查询字典项
   *
   * @param parentCode
   * @param code
   */
  public DubboResult<DictionaryResDTO> searchDictionaryInfo(DictionaryReqDTO dictionaryReqDTO);


  /** 新增字典信息 */
  public DubboResult insertDictionary(DictionaryReqDTO dictionaryReqDTO);

  /*** 查询字典信息 */
  public DubboResult<DictionaryInfoDTO> searchDictionary(Long dictionaryId);

  /** 字典列表 */
  public DubboResult<PageInfo<DictionaryInfoDTO>> listDictionary(DictionaryReqDTO dictionaryReqDTO);

  /** 更新字典 */
  public DubboResult updateDictionary(DictionaryReqDTO dictionaryReqDTO);

  /** 删除字典 */
  public DubboResult deleteDictionary(Long dictionaryId);

  /** 通过父级代码数组查询字典信息 */
  public DubboResult<DictionaryResDTO> getDictionaryByParentCode(List<String> parentCodes);

  /** 更新音频 */
  public DubboResult updateWavDictionary(DictionaryReqDTO dictionaryReqDTO);

}
