package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import lombok.Data;

/**
 * 督办记录对象
 *
 * @author liubao
 * @date 2024/07/02
 */
@Data
public class SupervisionDataDTO implements Serializable {

  private static final long serialVersionUID = 1237148891492724857L;

  /**
   * 自增主键
   */
  private Long id;

  /**
   * 案号代码
   */
  private String caseId;

  /**
   * 案号
   */
  private String caseName;

  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 督办人id
   */
  private String dbr;

  /**
   * 督办人名称
   */
  private String dbrmc;

  /**
   * 被督办人id
   */
  private String bdbr;

  /**
   * 被督办人法综账号（仲裁和诉讼案件才有）
   */
  private String yhdm;

  /**
   * 被督办人名称
   */
  private String bdbrmc;

  /**
   * 催办次数
   */
  private Integer urgeNumber;

  /**
   * 督办回复
   */
  private String reply;

  /**
   * 督办意见
   */
  private String suggestion;

  /**
   * 督办时间
   */
  private String createTime;

  /**
   * 回复时间
   */
  private String replyTime;

}
