package com.beiming.odr.user.api.dto.responsedto;


import com.beiming.odr.user.api.dto.AreasInfoDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserMenuInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import org.apache.dubbo.common.utils.CollectionUtils;

@Data
public class LoginInfoResDTO implements Serializable {

  private static final long serialVersionUID = 1939993907517003148L;

  private UserInfoDTO userInfo;
  private List<UserRoleInfoDTO> userRoles;
  private List<UserMenuInfoDTO> userMenuInfo;
  private String loginOutUrl;
  private Boolean isWeakPassword;

  /**
   * 登录用户 组织机构归属的行政区域信息
   */
  private AreasInfoDTO areasInfoDTO;

  public LoginInfoResDTO() {

  }

  public LoginInfoResDTO(UserInfoDTO userInfo, List<UserRoleInfoDTO> userRoles,
      List<UserMenuInfoDTO> userMenuInfo) {
    if (userInfo != null) {
      this.userInfo = userInfo;
      this.userInfo
          .setIsRealName(userInfo.getIsRealName() == null ? false : userInfo.getIsRealName());
      this.userInfo.setIsFacialVerify(
          userInfo.getIsFacialVerify() == null ? false : userInfo.getIsFacialVerify());
      if (!CollectionUtils.isEmpty(userMenuInfo)) {
        this.userMenuInfo = new ArrayList<>();
        this.userMenuInfo.addAll(userMenuInfo);
      }
      if (!CollectionUtils.isEmpty(userRoles)) {
        this.userRoles = new ArrayList<>();
        this.userRoles.addAll(userRoles);
      }
    }
  }
}
