package com.beiming.odr.user.api;

import java.util.ArrayList;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.PavilionInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DigitalGuangDongLoginReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DigitalGuangDongPavilionListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;


/**
 * 粤省事项目 数字广东所需要的所有接口
 */
@Valid
public interface DigitalGuangDongApi {

  /** 获取E法亭的信息列表 */
  DubboResult<PageInfo<PavilionInfoDTO>> getPavilionList(DigitalGuangDongPavilionListReqDTO req);
  
  /** 数字广东登录接口*/
  DubboResult<LoginInfoResDTO>  userLoginByDigitalGuangDong(DigitalGuangDongLoginReqDTO requestDTO);
  
  /** 获取E法亭的区域信息 */
  DubboResult<ArrayList<String>> getPavilionAreaName();
  
}
