package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import lombok.Data;

/**
 *
 * @author fhs 2019-07-17
 */
@Data
public class DigitalGuangDongLoginReqDTO implements Serializable {

  private static final long serialVersionUID = -6257639939898161265L;
  @NotBlank(message = "{user.phoneNotBlank}")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  @NotNull(message = "{user.phoneNotBlank}")
  private String phone;
  @NotNull(message = "{user.idCardNotBlank}")
  private String idCard;
  @NotNull(message = "{user.userNameNotBlank}")
  private String name;


}
