package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * 普通用户注册
 */
@Data
public class NewCaseUserRegisterReqDTO implements Serializable {


  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  private String mobilePhone;

  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "{user.idCardNotIncorrect}")
  private String idCard;

  /**
   * 是否实名
   */
  private Boolean isRealName;
  /**
   * 用户名称
   */
  private String userName;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;
  /**
   * 详细地址
   */
  private String detailedAddress;

}
