package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.MenuInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.MenuInfoReqDTO;

public interface MenuInfoServiceApi {
  /** 新增菜单 */
  DubboResult insertMenuInfo(MenuInfoReqDTO menuInfoRequestDTO);

  /** 获取菜单信息 */
  DubboResult<MenuInfoDTO> getMenuInfo(Long menuId);

  /** 获取菜单列表 */
  DubboResult<PageInfo<MenuInfoDTO>> listMenuInfo(MenuInfoReqDTO menuInfoRequestDTO);

  /** 更新菜单 */
  DubboResult updateMenuInfo(MenuInfoReqDTO menuInfoRequestDTO);

  /** 删除菜单 */
  DubboResult deleteMenuInfo(Long menuId);

  /**
   * 获取菜单列表，用于给角色管理权限
   */
  DubboResult<PageInfo<MenuInfoDTO>> listMenuInfoToRole();
}
