package com.beiming.odr.user.api.common.enums;

public enum GongDaoLoginEnum {

  PRC_IDENTITY_CARD("idcard", "中华人民共和国居民身份证", "09_00015-1"),
  PASSPORT("passport", "护照", "09_00015-7"),
  USCC("uscc", "统一社会信用代码", "09_00015-255"),
  OTHER("businesspermit", "营业许可证", "09_00015-255");

  private String gdCode;
  private String name;
  private String tdhCode;

  GongDaoLoginEnum(String code, String name, String tdhCode) {
    this.gdCode = code;
    this.name = name;
    this.tdhCode = tdhCode;
  }

  public static String getCardType(String name) {
    return getCardTypeEnum(name).getName();
  }

  public static GongDaoLoginEnum getCardTypeEnum(String name) {
    GongDaoLoginEnum result = PRC_IDENTITY_CARD; //默认身份证
    for (GongDaoLoginEnum cardTypeEnum : GongDaoLoginEnum.values()) {
      if (cardTypeEnum.getGdCode().equals(name)) {
        result = cardTypeEnum;
      }
    }
    return result;
  }
  public String getName() {
    return name;
  }

  public String getGdCode() {
    return gdCode;
  }

  public String getTdhCode() {
    return tdhCode;
  }

}
