package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import lombok.Data;

@Data
@EncryptDecryptData
public class UserEvaluateExport implements Serializable {
  /**
   * 评价人名称
   */
  @ExcelProperty(value = "评价人名称", index = 0)
  private String evaluateUserName;
  /**
   * 评价案件编号
   */
  @ExcelProperty(value = "案件编号/咨询编号", index = 1)
  @EncryptDecryptField
  private String evaluateCaseNo;
  /**
   * 手机号
   */
  @ExcelProperty(value = "手机号", index = 2)
  @EncryptDecryptField
  private String evaluateUserPhone;
  /**
   * 星级评价
   */
  @ExcelProperty(value = "星级评价", index = 3)
  private String grade;
  /**
   * 评价内容
   */
  @ExcelProperty(value = "评价内容", index = 4)
  private String evaluateContent;
}
