package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 当前系统登录用户信息
 *
 * @author xiaoying
 * @date 2022/05/25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LoginUserInfo implements Serializable {

  private static final long serialVersionUID = 1939993907517003148L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 登录用户组织机构id
   */
  private Long orgId = null;

  /**
   * 登录用户组织机构id集合 未避免以后出现一个登录用户两个区域 特设置为List
   */
  private List<Long> orgIds = null;

  /**
   * 登录用户区域编码
   */
  private String areacode;


  private List<String> areacodes = null;
}