package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.ConsultQuestionDTO;
import com.beiming.odr.user.api.dto.requestdto.ConsultQuestionListReqDTO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;

/**
 * 咨询问题服务列表
 *
 * @author liubao
 * @date 2024/06/18
 */
public interface ConsultQuestionServiceApi {

  /**
   * 添加咨询问题
   */
  DubboResult addQuestion(ConsultQuestionDTO reqDTO);

  /**
   * 修改咨询问题
   */
  DubboResult updateQuestion(ConsultQuestionDTO reqDTO);

  /**
   * 删除咨询问题
   */
  DubboResult deleteQuestion(Long id);

  /**
   * 咨询问题详情
   */
  DubboResult<ConsultQuestionDTO> searchConsultQuestion(Long id);

  /**
   * 咨询问题列表查询
   */
  DubboResult<PageInfo<ConsultQuestionDTO>> listConsultQuestions(ConsultQuestionListReqDTO dto);

  DubboResult<ArrayList<ConsultQuestionDTO>> listConsultQuestionsExcel(
      ConsultQuestionListReqDTO dto);

}
