package com.beiming.odr.user.api.dto;

import java.io.Serializable;

import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import lombok.Data;

@Data
public class UserRoleInfoDTO implements Serializable {
  /**
   * 角色名称
   */
  private String roleName;

  /**
   * 角色代码
   */
  private String roleCode;

  /**
   * 角色类型
   */
  private String roleType;

  private String roleTypeName;

  public String getRoleTypeName() {
    return RoleTypeEnum.getNameByCode(this.roleType);
  }
  /**
   * 机构id
   */
  private Long organizationId;

  /**
   * 机构name
   */
  private String organizationName;

  /**
   * 所属地区代码
   */
  private String areaCode;

  /**
   * 所属地区代码名称
   */
  private String areaFullName;

  /**
   * 用户id
   */
  private Long userId;
}
