package com.beiming.odr.user.api.dto.requestdto;


import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;


/**
 * 工作人员导入参数
 */
@Data
public class BackstageOrgImportReqDTO implements Serializable {


  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  @NotEmpty(message = "机构名称不能为空")
  private String name;

  /**
   * 机构英文名称
   */
  @NotEmpty(message = "机构英文名称不能为空")
  private String nameEn;


  /**
   * 父级name
   */
  private String parentName;

  /**
   * 调解类型名称
   */
  @NotEmpty(message = "调解类型不能为空")
  @Pattern(regexp = "^(人民调解|行政调解|仲裁调解|司法调解|商业调解|律师调解|公证调解|专业调解|行业调解|其他调解)$", message = "调解类型不合法")
  private String mediateName;

  /**
   * 座机电话
   */
  @NotEmpty(message = "座机电话不能为空")
  private String seatPhone;
  /**
   * 机构详细地址
   */
  @NotEmpty(message = "机构详细地址不能为空")
  private String detailedAddress;
  /**
   * 机构英文详细地址
   */
  @NotEmpty(message = "机构英文详细地址不能为空")
  private String detailedAddressEn;

  /**
   * 是否对群众开放
   */
  @NotEmpty(message = "机是否对群众开放不能为空")
  @Pattern(regexp = "^[是|否]$", message = "性别必须是'是'或'否'")
  private String isPublicOrg;
  /**
   * 机构类型代码
   */
  @NotEmpty(message = "机构类型不能为空")
  @Pattern(regexp = "^(调解机构|仲裁机构|公证机构|翻译机构|专家委员会|其他|法院)$", message = "机构类型不合法")
  private String orgNewTypeName;


  /**
   * 省名称
   */
  @NotEmpty(message = "省份不能为空")
  private String provinceName;

  /**
   * 市名称
   */
  @NotEmpty(message = "城市不能为空")
  private String cityName;

  /**
   * 区名称
   */
  @NotEmpty(message = "区县不能为空")
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;


  /**
   * 社区名称
   */
  private String communityName;
  /**
   * 机构简介
   */

  private String introduction;

  /**
   * 机构英文简介
   */
  private String introductionEn;

  /**
   *申请表关联唯一ID
   */
  private String originId;

  private Boolean isValid;

  private List<String> errorList;

  @JsonIgnore
  private BackstageOrganizationAddReqDTO orgAdd;

}
