package com.beiming.odr.user.api.dto.requestdto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.beiming.odr.user.api.util.StatusConverter;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.validation.constraints.NotBlank;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
public class ConsultQuestionDTO implements Serializable {

  private static final long serialVersionUID = 7851878297388953488L;

  /**
   * 自增主键
   */
  @ExcelIgnore
  private Long id;

  /**
   * 问题序号
   */
  @ExcelProperty(value = "问题序号", index = 0)
  @ColumnWidth(25)
  private Integer questionNum;

  /**
   * 问题描述
   */
  @ExcelProperty(value = "问题描述", index = 1)
  @ColumnWidth(50)
  @NotBlank(message = "{user.cosultQuestionNotNull}")
  private String questionDesc;

  /**
   * 问题答案
   */
  @ExcelProperty(value = "问题答案", index = 2)
  @ColumnWidth(50)
  private String questionAnswer;

  /**
   * 问题状态0-禁用 1-启用 2-已删除 3-待提交
   */
  @ExcelProperty(value = "问题状态", index = 3, converter = StatusConverter.class)
  @ColumnWidth(25)
  private Integer status;

  /**
   * 创建时间
   */
  @ExcelIgnore
  private String createTime;

  public String getCreateTime() {
    if (StringUtils.isNotBlank(createTime)) {
      DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
      LocalDateTime date = LocalDateTime.parse(createTime, formatter);
      return date.getYear() + "年" + date.getMonthValue() + "月" + date.getDayOfMonth() + "日";
    }
    return "";
  }
}
