package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.UserReportFormReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserReportReqDTO;
import com.beiming.odr.user.api.dto.responsedto.UserReportResDTO;
import com.github.pagehelper.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * 用户统计报表
 *
 * @author zhiguang
 */
public interface UserReportServiceApi {
  /**
   * 用户统计报表
   *
   * @param userReportReqDTO
   * @param isFromCache
   * @return
   */
  DubboResult<UserReportResDTO> getUserReport(UserReportReqDTO userReportReqDTO, boolean isFromCache);

  DubboResult getUserAccess(UserReportReqDTO userReportReqDTO, boolean isFromCache);

  PageInfo getUserLoginForm(UserReportFormReqDTO reportFormReqDTO);

  List<Long> getOrgId(String orgLevel, String orgType, String orgArea);

  List<Map<String, Object>> orgType();

  List<Map<String, Object>> orgArea();

  String getOrgType(Long orgId);
}
