package com.beiming.odr.user.api.dto.requestdto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jiangfan
 * @date 2024/04/15
 */
@Data
public class ClassicCaseDTO implements Serializable {

  /**
   * id
   */
  private String id;

  /**
   * 标题
   */
  private String title;
  /**
   * 英文标题
   */
  private String engTitle;

  /**
   * 内容
   */
  private String content;

  /**
   * 英文内容
   */
  private String engContent;

  /**
   * 标签
   */
  private String labels;

  /**
   * 标签
   */
  private List<String> label;


  /**
   * 创建人
   */
  private String createUser;
  /**
   * 发布人
   */
  private String publishUser;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;
  /**
   * 点击次数
   */
  private String viewNumber;

  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 暂存 1 发布 2 删除 3撤回
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 发布时间
   */
  private String publishTime;

  /**
   * 创建人名称
   */
  private String createUserName;

  public String getViewNumber() {
    if (StringUtils.isBlank(viewNumber)) {
      return "0";
    }
    return viewNumber;
  }
}

