package com.beiming.odr.user.api.dto.thirdpartydto.weizheng.req;

import com.beiming.odr.user.api.common.enums.thirdparty.WeiZhengAuthModelEnum;
import com.beiming.odr.user.api.dto.thirdpartydto.weizheng.WzAuthCodeExp;
import com.beiming.odr.user.api.dto.thirdpartydto.weizheng.WzBusinessInfo;
import com.beiming.odr.user.api.dto.thirdpartydto.weizheng.WzScopeLimit;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by Jache on 2019/09/04 15:16.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class WzAuthReqDTO implements Serializable {
  @NotNull
  private String accessToken; //当前可用的 access token
  @NotNull
  private String authType = "ScanAuth"; //认证类型，默认为字符串：ScanAuth
  /**
   * 身份证的认证模式，单次扫码认证中采用的
   * 模式，不同的认证模式其对用户认证的信息
   * 内容也不一样，详看 5.1 的身份证认证模式
   * （注：该字段与 niaMode 字段不能同时为
   * 空，mode 字段不为空时，则用户可以使用
   * 身份证进行认证）
   */
  private Integer mode;
  /**
   * 出入境证件的认证模式，单次扫码认证中采
   * 用的模式，不同的认证模式其对用户认证的
   * 信息内容也不一样，详看 5.1 的出入境证件
   * 认证模式（注：该字段与 mode 字段不能同
   * 时为空，niaMode 字段不为空时，则用户可
   * 以使用出入境的证件进行认证；两个字段都
   * 不为空时，用户使用身份证或者出入境证件
   * 都可以认证）
   */
  private Integer niaMode;

  private WzScopeLimit scopeLimit; //指定认证的区域范围（不指定时可不传该参数）

  private WzAuthCodeExp exp; //定二维码的有效时间（不指定时可不传该参数）

  private String businessExtraInfo; //<xml><phoneNum>188******29</phoneNum><nickName>卓</nickName></xml>

  private WzBusinessInfo businessInfo; //本次身份认证相关的业务信息字段

  public static WzAuthReqDTO getTwoModel(String accessToken) { //支持身份证和出入境证
    WzAuthReqDTO req = new WzAuthReqDTO();
    req.setAccessToken(accessToken);
    req.setMode(WeiZhengAuthModelEnum.ID_MODE_66.code());
    req.setNiaMode(WeiZhengAuthModelEnum.NIA_MODE_146.code());
    return req;
  }
}
