/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ReportCommonDTO
implements Serializable {
    private String date;
    private String num;
    private String value;
    private String percent;
    private String name;
    private String code;

    public ReportCommonDTO(String name, String num, Integer total) {
        this.setName(name);
        this.setNum(num);
        this.setPercent(this.div(new BigDecimal(Integer.valueOf(num == null ? "0" : num) * 100), new BigDecimal(total), 2));
    }

    public ReportCommonDTO(String name, String num, String value) {
        this.name = name;
        this.num = num;
        this.value = value;
    }

    public ReportCommonDTO() {
    }

    public ReportCommonDTO(String name, String value, String percent, String num) {
        this.name = name;
        this.value = value;
        this.percent = percent;
        this.num = num;
    }

    public ReportCommonDTO(String name, String percent) {
        this.name = name;
        this.percent = percent;
    }

    public String div(BigDecimal v1, BigDecimal v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        if (v2.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return v1.divide(v2, scale, RoundingMode.HALF_UP).toString();
    }

    public String getDate() {
        return this.date;
    }

    public String getNum() {
        return this.num;
    }

    public String getValue() {
        return this.value;
    }

    public String getPercent() {
        return this.percent;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportCommonDTO)) {
            return false;
        }
        ReportCommonDTO other = (ReportCommonDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        String this$num = this.getNum();
        String other$num = other.getNum();
        if (this$num == null ? other$num != null : !this$num.equals(other$num)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$percent = this.getPercent();
        String other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !this$percent.equals(other$percent)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        return !(this$code == null ? other$code != null : !this$code.equals(other$code));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReportCommonDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        String $num = this.getNum();
        result = result * 59 + ($num == null ? 43 : $num.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : $percent.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        return result;
    }

    public String toString() {
        return "ReportCommonDTO(date=" + this.getDate() + ", num=" + this.getNum() + ", value=" + this.getValue() + ", percent=" + this.getPercent() + ", name=" + this.getName() + ", code=" + this.getCode() + ")";
    }
}

