package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.fastjson.JSONArray;
import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.constants.ValidateMessage;
import com.beiming.odr.user.api.dto.UserCertificateInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Pattern;
import lombok.Data;


/**
 * 工作人员返回信息
 */
@Data
@EncryptDecryptData
public class BackstageUserInfoResDTO implements Serializable {

  public BackstageUserInfoResDTO() {

  }
  /**
   * 用户id
   */
  private Long userId;
  /**
   * 姓名
   */
  private String userName;

  /**
   * 账户名
   */
  private String loginName;
  /**
   * 手机号
   */
  @EncryptDecryptField
  private String mobilePhone;

  /**
   * 身份证
   */
  @EncryptDecryptField
  private String idCard;
  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = ValidateMessage.MOBILE_PHONE_INCORRECT)
  private String password;

  /**
   * 用户角色
   */
  private List<UserRoleInfoDTO> userRole;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;


  /**
   * 角色名称
   */
  private String roleName;

  /**
   * 用户状态
   */
  private String status;
  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 出生日期
   */
  private String birthday;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 职业类型
   */
  private String occupation;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 从业经历
   */
  private String experience;


  /** 用户地址 */
  private JSONArray userAddress;
  /**
   * 用户证件集合
   */
  private JSONArray userCertificates;
  /**
   * 对外号码
   */
  @EncryptDecryptField
  private String externalPhone;

  /**
   * 性别
   */
  private String sex;

  /**
   * 职务
   */
  private String job;

  /**
   * 工作年限
   */
  private String workYears;

  /**
   * 入职类型，
   */
  private String entryType;

  /**
   * 入职方式:
   */
  private String entryWay;

  /**
   * 是否地方财政保障或政府购买服务
   */
  private Boolean isFinancialSecurity;

  /**
   * 工作类型
   */
  private String workType;

  /**
   * 中文介绍
   */
  private String introduction;

  /**
   * 英文介绍
   */
  private String introductionEn;

  /**
   * 用户类别
   */
  private String userType;

  /**
   * 机构id
   */
  private  Long orgId;


  /**
   * 英文名
   */
  private String userNameEn;

  /**
   * 是否公开显示
   */
  private Integer show;

  /**
   * 是否禁用启用
   */
  private Integer enable;

  /**
   * 所属国家
   */
  private String country;

  private String headPortraitUrl;

  private Long roleOrgId;

  private String roleOrgName;

  private Date createOrUpdateTime;

  private List<UserCertificateInfoDTO> userCertificatesList;
}
