package com.beiming.odr.user.api.dto.thirdpartydto.weizheng.res;

import com.beiming.odr.user.api.common.enums.thirdparty.WeiZhengRetEnum;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by Jache on 2019/01/28 18:14.
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WzAPIResult implements Serializable {

  private static final long serialVersionUID = 4015536734461894652L;
  private Integer retCode;
  private String errorMsg;

  private WzAPIResult(String errorMsg) {
    this.retCode = WeiZhengRetEnum.SUCCESS.code();
    this.errorMsg = errorMsg;
  }

  public static WzAPIResult success() {
    return new WzAPIResult("成功");
  }

  public static WzAPIResult success(String errorMsg) {
    return new WzAPIResult(errorMsg);
  }

  public static WzAPIResult failed(WeiZhengRetEnum errorCode, String message) {
    return new WzAPIResult(errorCode.code(), message);
  }

  public static WzAPIResult failed(WeiZhengRetEnum errorCode) {
    return new WzAPIResult(errorCode.code(), errorCode.desc());
  }
}
