package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import lombok.Data;

/**
 * 机构统计报表对象
 *
 * @author liubao
 * @date 2024/07/05
 */
@Data
public class OrgDisputeStatisticsResDTO implements Serializable {

  private static final long serialVersionUID = 9133994140278007956L;
  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构名称
   */
  private String courtCode;

  /**
   * 机构类型code
   */
  private String orgTypeCode;

  /**
   * 机构类型名称
   */
  private String orgTypeName;

  /**
   * 人员总数
   */
  private Long personnelCount = 0l;

  /**
   * 收案数
   */
  private Long caseCount = 0l;

  /**
   * 已结案件数
   */
  private Long closedCaseCount = 0l;

  /**
   * 未结案件数
   */
  private Long openCaseCount = 0l;

  /**
   * 默认打开tab
   */
  private String defaultTab;

  public Long getOpenCaseCount() {
    return caseCount - closedCaseCount;
  }
}
