package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.AreasInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AreaReqDTO;
import com.beiming.odr.user.api.dto.responsedto.AreasResDTO;
import java.util.List;

public interface AreaServiceApi {

  DubboResult<AreasResDTO> searchAreasInfo(AreaReqDTO areaReqDTO);
  
  /**
   * 获取本级及下级区域信息
   * @param areaCode
   * @return
   */
  DubboResult<AreasResDTO> getLowerLevelAreasInfo(String areaCode);

  /**
   * 根据区域名称查询区域信息
   * @param areaName 区域名称
   * @return 区域信息
   */
  DubboResult<AreasInfoDTO> findAreaByName(String areaName);

  DubboResult<AreasInfoDTO> getAreaByCode(String code);

  DubboResult<AreasResDTO> searchAreaByparentId(AreaReqDTO areaReqDTO);


  DubboResult<AreasResDTO> searchAreaEngNameByCode(List<String> code);


}
