package com.beiming.odr.user.api.dto.responsedto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author jiangfan
 * @date 2024/05/08
 */
@Data
public class CooperationApplicationDTO implements Serializable {

  @ExcelIgnore
  private String id;

  /**
   * 联系人姓名
   */
  @ExcelIgnore
  private String name;

  /**
   *联系方式
   */
  @ExcelIgnore
  private String phone;

  /**
   * 邮箱
   */
  @ExcelIgnore
  private String email;

  /**
   * 地址
   */
  @ExcelIgnore
  private String address;

  /**
   * 机构简介
   */
  @ExcelIgnore
  private String introduce;

  /**
   * 申请方式
   */
  @ExcelProperty(value = "申请方式", index = 0)
  private String applyType;

  /**
   * 申请时间
   */
  @ExcelProperty(value = "申请时间", index = 1)
  private String appliyTime;

  /**
   * 机构名称
   */
  @ExcelProperty(value = "机构名称", index = 2)
  private String orgName;

  /**
   * 审核状态
   */
  @ExcelProperty(value = "审核状态", index = 3)
  private String examineStatus;

  /**
   * 审核时间
   */
  @ExcelProperty(value = "审核时间", index = 4)
  private String examineTime;

  /**
   * 审核结果 0 未审核  1 审核通过 2 审核不通过 3 已上线 4作废
   */
  @ExcelIgnore
  private Integer examineResult;

  /**
   * 备注原因
   */
  @ExcelIgnore
  private String examineRemark;

  /**
   * 创建时间
   */
  @ExcelIgnore
  private Date createTime;

  /**
   * 创建人
   */
  @ExcelIgnore
  private String createUser;

  /**
   * 修改人
   */
  @ExcelIgnore
  private String updateUser;

  /**
   * 修改时间
   */
  @ExcelIgnore
  private String updateTime;

  /**
   * 关联唯一ID
   */
  @ExcelIgnore
  private String originId;

  @ExcelIgnore
  private Integer version;

  @ExcelIgnore
  private String remark;

  @ExcelIgnore
  private String status;

  @ExcelIgnore
  private String error;

}
