package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.odr.user.api.dto.AreasInfoDTO;
import com.beiming.odr.user.api.dto.RoleInfoDTO;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Data;

/**
 * 查询服务人员授权信息返回参数
 */
@Data
public class SerchServicePersonGrantAuthInfoResDTO implements Serializable {

  public SerchServicePersonGrantAuthInfoResDTO() {

  }

  public SerchServicePersonGrantAuthInfoResDTO(List<RoleInfoDTO> roleList, String orgId, String orgName,
      List<AreasInfoDTO> serviceAreaList) {
    this.roleList = roleList;
    this.orgId = orgId;
    this.orgName = orgName;
    this.serviceAreaList = serviceAreaList;
  }

  /**
   * 职能类型列表
   */
  private List<RoleInfoDTO> roleList;
  /**
   * 服务机构名称
   */
  private String orgName;
  /**
   * 服务机构Id
   */
  private String orgId;

  /**
   * 服务区域list
   */
  private List<AreasInfoDTO> serviceAreaList;

  private Map<Long, List<AreasInfoDTO>> areasMap;

  private List<OrganizationResDTO> orgList;

  public SerchServicePersonGrantAuthInfoResDTO(List<RoleInfoDTO> roleList, List<OrganizationResDTO> orgList, Map<Long, List<AreasInfoDTO>> areasMap) {
    this.roleList = roleList;
    this.areasMap = areasMap;
    this.orgList = orgList;
  }
}
