package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 用户评价dto
 * @author zhiguang
 */
@Data
public class UserEvaluateDTO implements Serializable {
  /**
   * 被评价人id
   */
  private String userId;

  /**
   * 被评价人名称
   */
  private String userName;

  /**
   * 被评价用户类型
   */
  private String roleType;

  /**
   * 等级
   */
  private Integer grade;

  /**
   * 评价内容
   */
  private String evaluateContent;

  /**
   * 评价人id
   */
  private Long evaluateUserId;

  /**
   * 评价人名称
   */
  private String evaluateUserName;

  /**
   * 评价人手机号
   */
  private String evaluateUserPhone;

  /**
   * 评价案件id
   */
  private Long evaluateCaseId;
  
  /**
   * 评价案件编号
   */
  private String evaluateCaseNo;
  
  /**
   * 机构id
   */
  private Long evaluateOrgId;
  
  /**
   * 创建时间
   */
  private Date createTime;
  
  /**
   * 创建人
   */
  private String createUser;

  /**
   * 评价案件类型：调解，仲裁，诉讼
   */
  private String caseType;
}
