package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.Data;

/**
 * 案件信息短网址查询
 */
@Data
@EncryptDecryptData
public class ShortUrlCreateReqDTO implements Serializable {

  /**
   * '案件ID'
   */
  @NotBlank(message = "{case.id.cannot.be.empty}")
  private Long lawCaseId;

  /**
   * '案件编号
   */
  @NotBlank(message = "{case.number.cannot.be.empty}")
  @EncryptDecryptField
  private String caseNo;

//  /**
//   * '短网址
//   */
//  private String shortUrl;

  /**
   *  当事人ID
   */
  private Long userId;

  /**
   *  当事人类型
   */
  private String userType; //还未实际区分

  private Boolean isForever;
}
