package com.beiming.odr.user.api.dto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 字典
 */
@Data
public class DictionaryInfoDTO implements Serializable {


  public DictionaryInfoDTO(String parentCode, String code, String value, String twValue, String usValue, String name, String remark,
      String imgUrl, String orderNumber, String content, String usContent, String twContent, String cnValue) {
    this.parentCode = parentCode;
    this.code = code;
    this.value = value;
    this.name = name;
    this.remark = remark;
    this.imgUrl = imgUrl;
    this.orderNumber = orderNumber;
    this.content = content;
    this.twValue = twValue;
    this.usValue = usValue;
    this.usContent = usContent;
    this.twContent = twContent;
    this.cnValue = cnValue;
  }

  public DictionaryInfoDTO() {
    this.parentCode = null;
    this.code = "";
    this.value = "";
    this.name = "";
    this.remark = "";
    this.imgUrl = "";
    this.orderNumber = "";
    this.content = "";
  }
  /**
   * 字典id
   */
  private Long id;
  /**
   * 字典类型
   */
  private String parentCode;
  /**
   * 业务代码
   */
  private String code;

  /**
   * 业务名称
   */
  private String value;

  /**
   * 字典名称
   */
  private String name;

  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 图片url
   */
  private String imgUrl;

  /**
   * 排序
   */
  private String orderNumber;

  /**
   * 内容
   */
  private String content;

  /**
   * 业务值（台湾）
   */
  private String twValue;

  /**
   * 业务值（简中）
   */
  private String cnValue;

  /**
   * 业务值（美国）
   */
  private String usValue;

  /**
   * 内容（台湾）
   */
  private String twContent;

  /**
   * 业务值（美国）
   */
  private String usContent;

  /**
   * 内容（简中）
   */
  private String cnContent;

  public String localeValue() {
    switch (LocaleContextHolder.getLocale().toString().toLowerCase()) {
      case UserConst.EN:
        return usValue;
      case UserConst.TW:
        return twValue;
      default:
        return value;
    }
  }

  public String localeContent() {
    switch (LocaleContextHolder.getLocale().toString().toLowerCase()) {
      case UserConst.EN:
        return usContent;
      case UserConst.TW:
        return twContent;
      default:
        return content;
    }
  }
}
