package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;

import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.common.enums.OrgNewTypeEnums;
import lombok.Data;


/**
 * 后台机构新增请求参数
 */
@Data
public class BackstageOrganizationAddReqDTO implements Serializable {

  /**
   * 机构代码
   */
  private String code;

  private String courtCode;

  /**
   * 机构名称
   */
  private String name;

  /**
   * 父级id
   */
  private Long parentId;

  /**
   * 父级name
   */
  private String parentName;

  /**
   * 机构类型代码
   */
  private String typeCode;

  /**
   * 机构类型名称
   */
  private String typeName;

  /**
   * 调解类型代码
   */
  private String mediateCode;

  /**
   * 调解类型名称
   */
  private String mediateName;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区代码
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 座机电话
   */
  private String seatPhone;

  /**
   * 机构简介
   */

  private String introduction;

  /**
   * 机构详细地址
   */
  private String detailedAddress;


  /**
   * 是否对群众开放
   */
  private Boolean isPublicOrg;


  /**
   * 状态 0 正常 1 删除
   */
  private String status;
  /**
   * 机构英文详细地址
   */
  private String detailedAddressEn;

  /**
   * 机构英文简介
   */
  private String introductionEn;
  /**
   * 机构类型代码
   */
  private String orgNewTypeCode;

  /**
   * 机构英文名称
   */
  private String nameEn;

  /**
   *申请表关联唯一ID
   */
  private String originId;


  public BackstageOrganizationAddReqDTO() { }

  public BackstageOrganizationAddReqDTO(BackstageOrgImportReqDTO backstageOrgImportReqDTO) {
    this.name = backstageOrgImportReqDTO.getName();
    this.nameEn = backstageOrgImportReqDTO.getNameEn();
    this.provinceName = backstageOrgImportReqDTO.getParentName();
    this.introduction = backstageOrgImportReqDTO.getIntroduction();
    this.introductionEn = backstageOrgImportReqDTO.getIntroductionEn();
    this.detailedAddress = backstageOrgImportReqDTO.getDetailedAddress();
    this.detailedAddressEn = backstageOrgImportReqDTO.getDetailedAddressEn();
    this.provinceName = backstageOrgImportReqDTO.getProvinceName();
    this.cityCode = backstageOrgImportReqDTO.getCityName();
    this.areaName = backstageOrgImportReqDTO.getAreaName();
    this.streetName = backstageOrgImportReqDTO.getStreetName();
    this.communityName = backstageOrgImportReqDTO.getCommunityName();
    this.seatPhone = backstageOrgImportReqDTO.getSeatPhone();
    this.originId = backstageOrgImportReqDTO.getOriginId();
    if (backstageOrgImportReqDTO.getOrgNewTypeName() != null) {
      this.orgNewTypeCode = OrgNewTypeEnums.getCodeByName(backstageOrgImportReqDTO.getOrgNewTypeName());
    }
    if (backstageOrgImportReqDTO.getIsPublicOrg() != null) {
      this.isPublicOrg = "是".equals(backstageOrgImportReqDTO.getIsPublicOrg());
    }
    if (backstageOrgImportReqDTO.getMediateName() != null) {
      this.mediateName = backstageOrgImportReqDTO.getMediateName();
      this.mediateCode = MediationTypeEnum.getCodeByName(backstageOrgImportReqDTO.getMediateName());
    }

  }
}
