package com.beiming.odr.user.api.common.enums;

/**
 * @Description:状态枚举类型
 * @Author: heshui-fan
 * @Date: Created 2018/4/28
 */
public enum RoleTypeEnum {

  COMMON("普通用户"),
  CONSELOR("咨询师"),
  MEDIATOR("调解员"),
  JUDGE("办案法官"),
  ORG_MANAGE("机构管理员"),
  AREA_MANAGE("行政区域管理员"),
  DISPUTE_REGISTRAR("纠纷登记员"),
  SUPER_ADMIN("超级管理员"),
  ARBITRATOR("仲裁员"),
  OPERATOR("运维");


  private String name;

  RoleTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static String getCodeByName(String name) {
    String result = "MEDIATOR";
    RoleTypeEnum[] values = RoleTypeEnum.values();
    for (RoleTypeEnum typeEnum : values) {
      if (typeEnum.getName().equals(name)) {
        result = typeEnum.name();
      }
    }
    return result;
  };
  public static String getNameByCode(String code) {
    String result = "调解员";
    RoleTypeEnum[] values = RoleTypeEnum.values();
    for (RoleTypeEnum typeEnum : values) {
      if (typeEnum.name().equals(code)) {
        result = typeEnum.getName();
      }
    }
    return result;
  };
}
