package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Data;

/**
 * 普通用户-更新密码
 */
@Data
public class CommonUserUpdatePasswordReqDTO implements Serializable {

  @NotNull(message = "{user.userIdNotBlank}")
  private Long userId;
  /**
   * 旧密码
   */
//  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "旧密码格式错误")
  @NotBlank(message = "{user.oldPasswordNotBlank}")
  private String oldPassword;
  /**
   * 新密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "{user.newPasswordFormatError}")
  @NotBlank(message = "{user.passwordNotBlank}")
  private String newPassword;
}
