package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DataApiCallConfigListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DataApiCallRecordListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DataApiConfigListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DataApiConfigSaveReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DataApiCallConfigResDTO;
import com.beiming.odr.user.api.dto.responsedto.DataApiCallRecordResDTO;
import com.beiming.odr.user.api.dto.responsedto.DataApiConfigResDTO;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface DataApiServiceApi {

  DubboResult<Long> saveDataApiConfig(DataApiConfigSaveReqDTO reqDTO);

  DubboResult<DataApiConfigResDTO> getDataApiConfig(CommonIdReqDTO idReqDTO);

  DubboResult deleteDataApiConfig(CommonIdReqDTO idReqDTO);

  DubboResult<PageInfo<DataApiConfigResDTO>> pageDataApiConfig(DataApiConfigListReqDTO reqDTO);

  DubboResult<PageInfo<DataApiCallConfigResDTO>> pageDataApiCallConfig(DataApiCallConfigListReqDTO reqDTO);

  DubboResult<PageInfo<DataApiCallRecordResDTO>> pageDataApiCallRecord(DataApiCallRecordListReqDTO reqDTO);
}