package com.beiming.odr.user.api.common.enums.thirdparty;

/**
 * Created by Jache on 2019/09/04 16:35.
 */
public enum WeiZhengRetEnum {
  SUCCESS(0, "接口调用成功/身份认证成功（认证信息匹配）"),
  FAIL(1, "接口调用失败"),
  SERVER_ERROR(2, "服务器错误"),

  PARAMETER_ERROR(4002, "参数错误"),
  PUSH_THIRD_PARTY_ERROR(4004, "推送到第三方时失败（第三方未提供回调地址/推送失败）"),
  CLIENT_ID_NO_PASS(4009, "账号 client_id 权限校验不通过"),
  ACCESS_TOKEN_NO_PASS(4022, "accessToken 无效，检查生成时间是否已经超过 2 个小时，或者被其他人调用 getaccesstoken 接口将你的 accessToken 作废了"),
  QPS_UPPER_LIMIT(4010, "认证请求接口每秒并发（QPS）达到上限"),
  NUMBER_OF_AUTH_UPPER_LIMIT(4107, "认证次数（每日/每月/每年/总）限额达到上限"),
  AUTH_NO_PASS(4101, "身份认证不通过"),
  AUTH_SERVER_EXCEPTED(4103, "身份认证服务异常"),
  AUTH_API_TIMEOUT(4104, "认证接口调用超时"),
  PERSONNEL_DATA_NOT_EXIST(4109, "非库内人员：该人员身份信息未收录，无法完成身份认证"),





  ;
  private Integer code;

  private String desc;

  public Integer code() {
    return code;
  }

  public String desc() {
    return desc;
  }

  WeiZhengRetEnum(Integer code, String desc) {
    this.code = code;
    this.desc = desc;
  }
}
