package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.common.enums.OrganizationTypeEnum;
import lombok.Data;

import java.util.Date;

@Data
public class IntranetOrganizationReqDTO {

  /**
   * 关联平台的机构id
   */
  private String thirdId;

  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  private String name;

  /**
   * 关联平台的父机构id
   */
  private String thirdParentId;

  /**
   * 联系人
   */
  private String contactName;

  /**
   * 联系人电话
   */
  private String contactPhone;

  /**
   * 机构详细地址
   */
  private String detailedAddress;

  /**
   * 办公电话
   */
  private String seatPhone;

  /**
   * 机构简介
   */
  private String introduction;

  /**
   * 创建时间
   */
  private Date createDate;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  public BackstageOrganizationAddReqDTO convertBackstageOrgAddReqDTO() {
    BackstageOrganizationAddReqDTO reqDTO = new BackstageOrganizationAddReqDTO();
    reqDTO.setName(this.name);
    reqDTO.setProvinceCode("4400000000");
    reqDTO.setProvinceName("广东省");
    reqDTO.setCityCode("441900000000");
    reqDTO.setCityName("东莞市");
    reqDTO.setIntroduction(this.introduction);
    reqDTO.setDetailedAddress(this.detailedAddress);
    reqDTO.setTypeCode(OrganizationTypeEnum.OTHER_DISPUTE.name());
    reqDTO.setTypeName(OrganizationTypeEnum.OTHER_DISPUTE.getName());
    reqDTO.setMediateCode(MediationTypeEnum.PEOPLE_MEDIATION.name());
    reqDTO.setMediateName(MediationTypeEnum.PEOPLE_MEDIATION.getName());
    reqDTO.setStatus(status);
    return reqDTO;
  }
}