/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.util.sm4util;

import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import com.beiming.odr.user.api.util.sm4util.SM4Utils;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class EncryptDecryptUtilCopy {
    public static <T> T encrypt(Field[] declaredFields, T paramsObject) throws IllegalAccessException {
        for (Field field : declaredFields) {
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(paramsObject);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            if (StringUtils.isNotEmpty((CharSequence)value) && !EncryptDecryptUtilCopy.checkIsEncrypt(value).booleanValue()) {
                field.set(paramsObject, "xy_db_encrypt_" + SM4Utils.encryptDataCbcCopy(value));
                continue;
            }
            field.set(paramsObject, value);
        }
        return paramsObject;
    }

    public static <T> T decrypt(T result) throws IllegalAccessException {
        Field[] declaredFields;
        Class<?> resultClass = result.getClass();
        for (Field field : declaredFields = resultClass.getDeclaredFields()) {
            EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
            if (Objects.isNull(sensitiveField)) continue;
            field.setAccessible(true);
            Object object = field.get(result);
            if (!(object instanceof String)) continue;
            String value = (String)object;
            if (StringUtils.isNotEmpty((CharSequence)value) && EncryptDecryptUtilCopy.checkIsEncrypt(value).booleanValue()) {
                field.set(result, SM4Utils.decryptDataCbcCopy(value.substring(14, value.length())));
                continue;
            }
            field.set(result, value);
        }
        return result;
    }

    private static Boolean checkIsEncrypt(String source) {
        return source.contains("xy_db_encrypt_");
    }
}

