package com.beiming.odr.user.api;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.AreasInfoDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RecommendOrganizationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelOrgInfoSingleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.HomeDataCountResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgInfoSingleResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgTreeResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonNumberResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;


public interface OrganizationServiceApi {
  
  /**
   * 智能推荐调解机构
   * @param recommendOrganizationReqDTO
   * @return
   */
  public DubboResult<OrganizationResDTO> getRecommendOrganization(RecommendOrganizationReqDTO recommendOrganizationReqDTO);

  /**
   * 选择调解机构列表分页
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getMediateOrganizationListPage(OrganizationListReqDTO organizationListReqDTO);

  /**
   * 获取机构列表分页
   *
   * @param reqDTO
   * @param type   为1请求有效数据 为2 请求包含禁用的
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPage(OrganizationListReqDTO reqDTO, Integer type);




  /**
   * 获取机构列表分页new
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPageNew(OrganizationListReqDTO organizationListReqDTO);


  public DubboResult<Integer> getOrgNums();


  /**
   * 获取机构列表类型分页
   * @return
   */
  public DubboResult<ArrayList<OrganizationResDTO>> getOrganizationTypeList();

  /**
   * 获取机构详情
   * @param orgId
   * @return
   */
  public DubboResult<OrganizationResDTO> getOrganizationDetail(Long orgId);

  public DubboResult<OrganizationResDTO> getOrganizationById(Long orgId);
  DubboResult<ArrayList<OrganizationResDTO>> getOrgList(List<Long> orgIds);
  
  /**
   * 查询机构下服务人员的数量
   * @param orgIds
   * @return
   */
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(List<Long> orgIds);
  
  /**
   * 查询首页统计数据
   * @return
   */
  public DubboResult<HomeDataCountResDTO> getHomeDataCount();
  
  /**
   * 得到机构管理员所在的机构id
   */
  DubboResult<Long> getOrgIdByOrgManageUser(Long userId);
  
  /**
   * 通过机构管理员或区域管理员id获取所在区域
   * @param userId
   * @return
   */
  public DubboResult<String> getAreaCodeByManageUserId(Long userId);
  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoList(@Valid SelOrgInfoSingleReqDTO arg0);
  /**
   * <pre>
   * 传入调解员或机构管理员的userId查询其绑定的所以机构的简易信息
   * @param userId
   * @return
   */
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoByUserId(String userId);
  
  /**
   * 根据机构id和要查询的角色类型，返回对应的角色类型的用户详情
   * 
   * @param orgId 机构id
   * @param roleTypeEnumList 角色类型列表
   */
  public DubboResult<ArrayList<UserInfoDTO>> getUserInfoByOrgIdAndRoleType(Long orgId,
      List<RoleTypeEnum> roleTypeEnumList);

  /**
   * 根据机构id返回是否具有司法确认
   */
  Integer selectIsJudicialConfirmation(Long orgId);

  /**
   *@Author TangYu
   *@Description 根据名称获取调解机构信息
   *@Date 14:16 2019/10/29
   */
  public DubboResult<OrgInfoSingleResDTO> getOrgSingleInfoByOrgName(String orgName);
  /**
   * 查询所有的调解机构构建组织树。
   */
  DubboResult<ArrayList<OrgTreeResDTO>> getOrgTree(String serviceAreaCode);
  /**
   * 通过code 得到地区信息值
   */
  DubboResult<AreasInfoDTO> queryAreasInfo(String code);

  /**
   * 获取下一级机构详情
   */
  DubboResult<ArrayList<OrganizationResDTO>> getOrgByParentId(Long parentOrgId);
  DubboResult<ArrayList<Long>> selectAllByParentIdAndId(Long parentOrgId);
  /**
   * 根据当前组织id获取下级被禁用的组织机构
   * @param parentOrgId
   * @return
   */
  DubboResult<ArrayList<OrganizationResDTO>> getOrgByParentIdIsValid(Long parentOrgId);

  /**
   * 当事人端搜索机构时候，特定业务含义的搜索
   */
  DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListBySpecialBusiness(OrganizationListReqDTO organizationListReqDTO);

  /***
   * 获取二级分局机构名称
   **/
  JSONObject getSecondOrganization();

  /***
   * 根据机构id获取机构当前调解人员
   **/
  DubboResult<ServicePersonNumberResDTO> getMediatorNumberByOrgId(List<Long> orgIds, String name);

  DubboResult<OrganizationResDTO> getOrganization(Long orgId);

  DubboResult<ArrayList<OrganizationResDTO>> getAllOrgList();
}
