package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.UserOrganizationExamine;
import com.beiming.odr.user.api.dto.requestdto.UserOrganizationExamineHistory;
import com.github.pagehelper.PageInfo;

/**
 * @author 46915
 * @date 2022/12/07
 * @describes
 */
public interface UserOrganizationExamineServiceApi {

  /**
   * 发布调解员与调解机构审核
   */
  DubboResult publishExamine(UserOrganizationExamine userOrganizationExamine);

  /**
   * 审核调解员与调解机构
   */
  DubboResult examine(UserOrganizationExamine userOrganizationExamine);

  /**
   * 分页获取调解员与调解机构审核列表
   */
  DubboResult<PageInfo<UserOrganizationExamine>> getExamineData(String type, String name, Integer examineStatus, String startTime, String endTime,
      Integer pageSize, Integer pageNum, String currentUserId);

  /**
   * 新增变更记录
   */
  DubboResult addExamineHistory(UserOrganizationExamine userOrganizationExamine);


  /**
   * 分页获取调解员与调解机构变更数据列表
   */
  DubboResult<PageInfo<UserOrganizationExamineHistory>> getExamineHistoryData(String type, Long relationId, Integer pageSize, Integer pageNum);


}