package com.beiming.odr.user.api.common.enums;

import com.beiming.framework.domain.DubboResultCode;

public enum DigitalGuangDongErrorCode implements DubboResultCode {
  SUCCESS(0, "成功"), ILLEGAL_PARAMETER(1000000001, "非法参数"), EXCEPTED(1000000002, "异常"),
  /**
   * 用户未登录
   */
  USER_NOT_LOGIN(1000000003, "用户未登录"),
  /**
   * 认证令牌过期
   */
  AUTH_TOKEN_EXPIRE(1000000004, "认证令牌过期"),
  
  /**
   * 权限不足
   */
  ACCESS_DENIED(1000000005, "权限不足"),
  /**
   * 结果为空
   */
  RESULT_EMPTY(1000000006, "结果为空"),

  /**
   * 操作数据库失败
   */
  FAIL_DATABASE(1000000007, "操作数据库失败"),
  /**
   * 头参校验失败
   */
  HEADER_PARAMETER_VALIDATE_FAIL(1000000008, "头参校验失败"),
  /**
   * 用户退出登录
   */
  USER_LOGIN_OUT(1000000009, "用户退出登录"),

  /**
   * 用户已经在其他地方重新登录
   */
  USER_ALREADY_LOGIN(1000000010, "用户已经在其他地方重新登录"),
  UPLOAD_FILETYPE_ERROR(1000000011, "上传文件类型有误，请上传类型为JPEG,PNG,GIF,ZIP,DOC,DOCX,XLSX,XLS,PDF,RAR,JPG等类型的文件"),
  UPLOAD_FILENAME_TOLANG(1000000012, "上传文件名过长")
  ;

  private int code;
  private String desc;

  public String desc() {
    return desc;
  }

  DigitalGuangDongErrorCode(int code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public int getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }

  @Override
  public int value() {
    // TODO Auto-generated method stub
    return 0;
  }
}
