package com.beiming.odr.user.api.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import lombok.Data;

/**
 * @author guming
 * @version 1.0
 * @email guming@bmsoft.com.cn
 * @date 2024/6/19
 * @Desc
 */
@Data
public class RecommendAppsDTO implements Serializable {

  private static final long serialVersionUID = 7851878297388953488L;
  /**
   * 自增主键
   */
  private Long id;


  /**
   * 应用名称
   */
  private String appName;
  /**
   * 应用地址
   */
  private String appUrl;

  /**
   * 应用状态  1-发布  2 删除 3 隐藏
   */
  private Integer status;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private String createTime;

  /**
   * 发布时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private String publishTime;

  /**
   * 更新人
   */
  private String updateUser;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private String updateTime;

  /**
   * 图片ID
   */
  private String imgFileId;


  /**
   * 创建人
   */
  private String createUser;

  /**
   * 备注
   */
  private String remark;

  /**
   * 预览地址
   */
  private String imgUrl;



}
