package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.constants.ValidateMessage;

/**
 * 身份认证
 */
@Data
public class RealNameAuthenticationReqDTO implements Serializable {
  /**
   * 身份证
   */
  /**
   * 身份证
   */
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = ValidateMessage.ID_CARD_NOT_INCORRECT)
  private String idCard;

  /** 姓名 */

  @NotBlank(message = "{user.userNameNotBlank}")
  private String userName;
}
