package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import lombok.Data;

@Data
public class RecommendOrganizationReqDTO implements Serializable {

  /**
   * 调解类型代码
   */
  @NotNull(message = "{user.mediateCodeNotBlank}")
  private MediationTypeEnum mediateCode;

  /**
   * 纠纷类型代码
   */
  private String disputeTypeCode;

  /**
   * 纠纷发生地代码
   */
  @NotEmpty(message = "{user.disputeAreaCodeNotBlank}")
  private String disputeAreaCode;

  /**
   * 纠纷发生地地址等级
   */
  @NotNull(message = "{user.disputeAreaLevelNotBlank}")
  private Integer disputeAreaLevel;

}
