package com.beiming.odr.user.api.common.constants;

/**
 * 校验异常信息
 *
 * @author lb
 *
 */
public class OldValidateMessage {

  /**
   * 可配合validationMessage.properties使用
   */
  public static final String MOBILE_PHONE_INCORRECT = "{mobilePhone.incorrect}";
  public static final String PLATFORM_NOT_NULL = "{platform.notNull}";
  public static final String SMSCODE_NOTBLANK = "{smsCode.notBlank}";
  public static final String REFRESH_TOKEN_NOT_BLANK = "{refreshToken.notBlank}";
  public static final String ID_NOT_BLANK = "{id.notBlank}";
  /** 备注不能为空 */
  public static final String REMARK_CANNOT_EMPTY = "{remark.cannotEmpty}";
  /** 没有文件上传 */
  public static final String NOT_FILE_UPLOAD = "{file.notFileUpload} ";
  /** 无效请求 */
  public static final String ILLEGAL_REQUEST = "{file.illegalRequest}";
  /** 未找到相应文件 */
  public static final String FILE_NOT_FOUND = "{file.fileNotFound}";
  /** 文件名为空 */
  public static final String FILE_NAME_IS_EMPTY = "{file.fileNameIsEmpty}";
  /** 文件大小为空 */
  public static final String FILE_SIZE_IS_EMPTY = "{file.fileSizeIsEmpty}";
  /**
   * 文件处理失败
   */
  public static final String FAIL_FILE = "{file.fail}";
  /**
   * 文件类型有误
   */
  public static final String FILE_TYPE_IS_WRONG = "{file.fileTypeIsWrong}";

  /** 传入参数为空 */
  public static final String PARAMETER_IS_NULL = "{common.parameterIsNull}";
  /** 未找到相应文件 */
  public static final String OTHER_ERROR = "{file.fileNotFound}";

  /**
   * 从数据库里没有找到相关数据
   */
  public static final String RESULT_EMPTY = "{database.result.empty}";

  /** 添加贷款人失败 */
  public static final String ADD_LOAN_USER_FAIL = "{add.loan.user.fail}";
  /** 添加公证失败 */
  public static final String ADD_NOTARY_BUSINESS_FAIL = "{add.notary.business.fail}";
  /** 更新公证失败 */
  public static final String UPDATE_NOTARY_BUSINESS_FAIL = "{update.notary.business.fail}";
  /** 填写的用户为公证员本人，请重新选择公证员 */
  public static final String LOAN_USER_NOT_NOTARY_USER = "{loan.user.not.notary.user}";
  /** 贷款人为您本人，请交由其他同事处理 */
  public static final String LOAN_USER_NOT_BANK_USER = "{loan.user.not.bank.user}";

  /** 名称不能为空 */
  public static final String NAME_NOT_BLANK = "{name.notBlank}";
  /** 用户类型不能为空 */
  public static final String USER_TYPE_NOT_NULL = "{userType.notNull}";
  /** 身份证格式不对 */
  public static final String ID_CARD_NOT_INCORRECT = "{idCard.incorrect}";
  /** 角色id不能为空 */
  public static final String ROLE_ID_NOT_BLANK = "{roleId.notBlank}";
  /** code不能为空 */
  public static final String CODE_NOT_BLANK = "{code.notBlank}";
  /** value不能为空 */
  public static final String VALUE_NOT_BLANK = "{value.notBlank}";
  /** 驳回理由不能为空 */
  public static final String FAILREASON_NOT_NULL = "{fail.reason.notNull}";
  /** 菜单正在使用 */
  public static final String MENU_BEING_USED = "{menu.beingUsed}";
  /** id不存在 */
  public static final String ID_NOT_EXISTS = "{id.notExists}";
  /** 名称已经存在 */
  public static final String NAME_EXISTS = "{name.exists}";
  /** 菜单正在使用 */
  public static final String ROLE_BEING_USED = "{role.beingUsed}";
  /** 有一方未加入视频 */
  public static final String REAL_START_TIME_NOT_NULL = "{realStartTime.notNull}";
  /** 不能操作当前记录 */
  public static final String CAN_NOT_OPERATE_CURRENT_RECORD = "{errorCode.canNotOperateCurrentRecord}";
  /** 公证业务状态不正确 */
  public static final String NOTARY_BUSINESS_STATUS_INCORRECT = "{errorCode.notaryBusinessStatusIncorrect}";
  /** 用户不在参会列表 */
  public static final String USER_NOT_IN_JOIN_USER_ID = "{errorCode.userNotInJoinUserId}";
}
