package com.beiming.odr.user.api.dto;

import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * 案件统计分析入参
 *
 * @author liubao
 * @date 2024/07/23
 */
@Data
@EncryptDecryptData
public class CaseStatisticsUserReqDTO implements Serializable {

  private static final long serialVersionUID = -5345452669485325038L;

  @EncryptDecryptField
  private String caseName;

  /**
   * 检索关键词
   */
  private String keyWord;

  /**
   * 机构类型
   */
  private String orgNewTypeCode;

  /**
   * 角色类型
   */
  private String userRole;

  /**
   * 开始时间
   */
  private String startTime;

  /**
   * 结束时间
   */
  private String endTime;

  /**
   * 机构id列表
   */
  private List<Long> orgIds;
}
