package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.OrganizationEnableDTO;
import com.beiming.odr.user.api.dto.SyncOrganizationRrrorDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrgSearchByThirdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrgSearchLikeReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrgUpdateThirdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SyncOrganizationDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.SyncOrganizationFlag;
import java.util.ArrayList;
import java.util.List;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface BackstageOrganizationServiceApi {

  /**
   * 新增机构信息
   */
  public DubboResult<Long> addBackstageOrganization(BackstageOrganizationAddReqDTO req);

  /**
   * 编辑机构信息
   */
  public DubboResult updateBackstageOrganization(BackstageOrganizationUpdateReqDTO req);


  /**
   * 查询机构信息
   */
  public DubboResult<BackstageOrganizationResDTO> searchBackstageOrganization(BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息 列表
   */
  public DubboResult<PageInfo<BackstageOrganizationResDTO>> listBackstageOrganization(BackstageOrganizationListReqDTO req);

  public DubboResult<ArrayList<BackstageOrganizationResDTO>> listBackstageOrganizationAll();

  public DubboResult<SyncOrganizationFlag> addBackstageOrganizationFlag(
      SyncOrganizationDTO organization);

  public DubboResult<SyncOrganizationFlag> updateBackstageOrganizationFlag(
      SyncOrganizationDTO organizationTdh);

  public DubboResult insertSyncOrganizationRrror(SyncOrganizationRrrorDTO req);

  /**
   * 批量新增机构
   */
  public DubboResult<Integer> addBackstageOrganizationList(List<BackstageOrganizationAddReqDTO> list);
  /**
   * 指定机构角色类型查询上面的机构id
   */
  DubboResult<ArrayList<Long>> findLeaderOrgByOrgRoleType(Long currentOrgId, String orgRoleType);

  /**
   * 根据thirdId查询机构信息
   */
  DubboResult<BackstageOrganizationResDTO> findByThirdId(BackstageOrgSearchByThirdReqDTO req);

  /**
   * 更新thirdId
   */
  DubboResult updateOrgThirdId(BackstageOrgUpdateThirdReqDTO req);

  /**
   * 根据机构类型和名称模糊匹配
   */
  DubboResult<BackstageOrganizationResDTO> findByTypeAndLikeName(BackstageOrgSearchLikeReqDTO req);

  DubboResult updateOrganizationStatus(Long orgId, String status);

  /**
   * 查询被禁用的机构id数组
   * 如果需要加查询条件，后者可以进行加入
   */
  DubboResult<ArrayList<Long>> findDisableOrganization();
  /**
   * 通过机构ids 查询出机构
   */
  DubboResult<ArrayList<BackstageOrganizationResDTO>> queryOrgListByIds(List<Long> ids);


  DubboResult<BackstageOrganizationResDTO> getByOriginId(String id);

  /**
   * 禁用/启用
   * @param req
   * @return
   */
  DubboResult enable(OrganizationEnableDTO req);
}
