package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.CaseStatisticsUserReqDTO;
import com.beiming.odr.user.api.dto.OrgDisputeStatisticsResDTO;
import com.beiming.odr.user.api.dto.StatisticsOrgUserReqDTO;
import com.beiming.odr.user.api.dto.StatisticsOrgUserResDTO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 纠纷统计服务列表
 *
 * @author liubao
 * @date 2024/07/05
 */
public interface DisputeStatisticsServiceApi {

  /**
   * 服务团队解纷主体机构信息查询
   */
  DubboResult<ArrayList<OrgDisputeStatisticsResDTO>> organizationList(
      CaseStatisticsUserReqDTO reqDTO);

  /**
   * 获取机构下人员统计
   */
  DubboResult<ArrayList<Map<String, Object>>> getOrgRyCount(List<Long> orgIds);

  /**
   * 获取所有人员及类型
   */
  DubboResult<ArrayList<Map<String, Object>>> userList(CaseStatisticsUserReqDTO reqDTO);

  /**
   * 查询机构下所有人员
   */
  DubboResult<PageInfo<StatisticsOrgUserResDTO>> orgUserList(StatisticsOrgUserReqDTO reqDTO);
}
